function showPoiDeals() {
    const elem = $("#poiPopupPanel .item-info-data");
    if(elem.hasClass("deals-shown")) {
        elem.removeClass("deals-shown");
    } else {
        elem.addClass("deals-shown");
    }
    getAMap().onAfterMapAreaResize();
}

function hidePoiDeals() {
    $("#poiPopupPanel .item-info-data").removeClass("deals-shown");
    getAMap().onAfterMapAreaResize();
}

const aboutVivoInfo = {
    title: [
        { lang: "EN", value: "Retail Meets Architecture" },
        { lang: "ZH-CHS", value: "零售与建筑的结合" }
    ],
    description: [
        {
            lang: "EN",
            value: "<p>VivoCity is an iconic retail, entertainment & lifestyle destination that constantly surprises and stimulates visitors with its vibrant mix of retail and entertainment concepts. It features wide, open spaces for waterfront relaxation and entertainment, and a full calendar of exciting festivals and events that will draw both locals and foreign visitors.<p>"
        },
        {
            lang: "ZH-CHS",
            value: "<p>怡丰城是新加坡规模最大的购物中心，内有超过300间商店提供琳琅满目的商品和休闲服务。逾100万平方英尺的可租赁面积分布于地上三层和地下两层。一层设有户外广场、中庭，喷泉水流, 沿着港湾有长约300米的滨海步行道；二楼则有户外游乐场、；三楼视野辽阔，远眺海景、山色与缆车，设有空中花园、露天剧场及戏水池。怡丰城全年举办各类型的推广活动，例如文化消闲、户外表演、大型节日和市集等以吸引当地人和外国游客。<p>"
        }
    ],
    medias: [
        {
            link: '/../app/assets/images/client/vivo_about.jpg',
            type: 'IMAGE'
        }
    ]
};

const aboutsentosa = {
    title: [
        { lang: "EN", value: "Getting To Sentosa" },
        { lang: "ZH-CHS", value: "前往圣淘沙" }
    ],
    description: [
        {
            lang: "EN",
            value: "<p>Getting to Sentosa from VivoCity is a breeze via these 3 easy ways:<p>" +
                "<table>" +
                "<tr>" +
                "<td><img src='/../app/assets/images/icons/monorail.png' alt=''></td>" +
                "<td>Hop on the Sentosa Express (Lobby L, Level 3). Sentosa Express tickets can be purchased at the Sentosa Concourse on Level 3.</td>" +
                "<td><div class='default-btn' data-item='672b60975351052ffe16fee4'>Show on Map</div></td>" +
                "</tr>" +
                "<tr>" +
                "<td><img src='/../app/assets/images/icons/walk.png' alt=''></td>" +
                "<td>Take the scenic route across the boardwalk from the Promenade (facing Sentosa)</td>" +
                "<td><div class='default-btn' data-item='672b60805351052ffe16fe1c'>Show on Map</div></td>" +
                "</tr>" +
                "<tr>" +
                "<td><img src='/../app/assets/images/icons/bus.png' alt=''></td>" +
                "<td>Board RWS8 from the bus stop right outside VivoCity (along Telok Blangah Road).</td>" +
                "<td><div class='default-btn' data-item='672b60975351052ffe16fef6'>Show on Map</div></td>" +
                "</tr>" +
                "</table>"
        },
        {
            lang: "ZH-CHS",
            value: "<p>通过以下三个便捷的方式从怡丰城前往圣淘沙：<p>" +
                "<table>" +
                "<tr>" +
                "<td><img src='/../app/assets/images/icons/monorail.png' alt=''></td>" +
                "<td>乘搭圣淘沙捷运列车位于L 大厅三楼, 需购买车票入岛</td>" +
                "<td><div class='default-btn' data-item='672b60975351052ffe16fee4'>Show on Map</div></td>" +
                "</tr>" +
                "<tr>" +
                "<td><img src='/../app/assets/images/icons/walk.png' alt=''></td>" +
                "<td style='width: 1078px'>面对圣淘沙，沿着景色优美的海滨长廊步行（一楼）</td>" +
                "<td><div class='default-btn' data-item='672b60805351052ffe16fe1c'>Show on Map</div></td>" +
                "</tr>" +
                "<tr>" +
                "<td><img src='/../app/assets/images/icons/bus.png' alt=''></td>" +
                "<td>从怡丰城外的巴士车站（沿着直落布兰雅路）乘搭 RWS8 巴士</td>" +
                "<td><div class='default-btn' data-item='672b60975351052ffe16fef6'>Show on Map</div></td>" +
                "</tr>" +
                "</table>"
        }
    ],
    medias: [
        {
            link: '/../app/assets/images/client/sentosa.png',
            type: 'IMAGE'
        }
    ]
};

function showInfoWithActions(info) {

    showOneInfoPanel(info);

    $("div.info-body div.info-desc div.default-btn").on('click', function() {
        const id = $(this).attr("data-item");
        if(id) {
            const poi = getPOIById(id) || getServiceById(id);
            if(poi) {
                hideOneInfoPanel(); showMapPanel(); onSelectPoi(poi);
            }
        }
    });
}


customOnClickAd = function(ad) {
    stopScreenSaver();
    if(ad.streamType === "TOP_BANNER") {
        showOneInfoPanel(ad);
    }
};