const defaultLanguage = "EN";
const statsLang = "EN";
let currentLanguage = defaultLanguage;
let defaultContentLanguage = defaultLanguage;

const keyboardlayouts = {
    EN: 'qwerty',
    "ZH-CHS": 'qwerty'
};
const momentlocale = {
    EN: 'en',
    "ZH-CHS": 'zh_cn'
};

const langNames = {
    EN: "EN",
    "ZH-CHS": "简"
};

const dateFormats = {
    EN: 'DD MMM YY',
    "ZH-CHS": 'LL'
};

const translations = {
    welcome: {
        EN: "VIVOCITY SMART DIRECTORY",
        "ZH-CHS": "怡丰城智能导览"
    },
    about: {
        EN: "About VivoCity",
        "ZH-CHS": "关于怡丰城"
    },
    home: {EN: "Home", AR: "الصفحة الرئيسية", "ZH-CHS": "主页"},
    floor: {EN: "Level", AR: "ألطابق", "ZH-CHS": "楼层"},
    shop: {EN: "Shopping", AR: "المتاجر", "ZH-CHS": "购物"},
    leisure: {EN: "Lifestyle", AR: "الترفيه", "ZH-CHS": "生活闲娱"},
    stay: {EN: "Stay", AR: "الفنادق", "ZH-CHS": "住宿"},
    dine: {EN: "Dining", AR: "المطاعم", "ZH-CHS": "餐饮"},
    services: {EN: "Services & Facilities", AR: "الخدمات و التسهيلات", "ZH-CHS": "服务与设施"},
    facilities: {EN: "Services", AR: "الخدمات", "ZH-CHS": "服务"},
    categories: {EN: "Categories", AR: "الفئات", "ZH-CHS": "分类"},
    deals: {EN: "Store Highlights", "ZH-CHS": "商店优惠"},
    kids: {EN: "Kids Club Offers", "ZH-CHS": "儿童俱乐部优惠"},
    events: {EN: "What's On", AR: "النشاطات", "ZH-CHS": "展览与活动"},
    sentosa: {EN: "Sentosa Island", AR: "", "ZH-CHS": "圣淘沙岛"},
    infos: {EN: "Mall Happenings", "ZH-CHS": "最新动态"},
    events_2: { EN: "Events", "ZH-CHS": "展览与活动"},
    new_stores: { EN: "New Stores", "ZH-CHS": "新商店"},
    promo: { EN: "PROMO", "ZH-CHS": "促销活动"},
    all: { EN: "ALL", "ZH-CHS": "全部"},
    customer_service: {EN: "Customer Service", AR: "خدمة الزبائن", "ZH-CHS": "客户服务"},
    survey: {EN: "Survey", AR: "استبيان", "ZH-CHS": "调查"},
    map: {EN: "Floor Guide", AR: "عرض الخريطة", "ZH-CHS": "商场指南"},
    art: {EN: "Art Pieces", AR: "", "ZH-CHS": "艺术作品"},
    language: {EN: "Language", AR: "اللغة", "ZH-CHS": "语言"},
    more: {EN: "More", AR: "جميع الخدمات", "ZH-CHS": "更多设施"},
    submit: {EN: "Submit", AR: "إرسال", "ZH-CHS": "提交"},
    clear: {EN: "Clear", AR: "Clear", "ZH-CHS": "Clear"},
    tap_to_start: {
        EN: "Tap to start!",
        "ZH-CHS": "点击开始"
    },
    more_info: {EN: "More Information", AR: "معلومات اكثر", "ZH-CHS": "更多信息"},
    back: {EN: "Back", AR: "رجوع", "ZH-CHS": "返回"},
    close: {EN: "Close", AR: "إغلاق", "ZH-CHS": "关闭"},
    remove: {EN: "Remove", AR: "إزالة", "ZH-CHS": "移除"},
    height_adjust: { EN:"Adjust Height", AR:"ضبط الارتفاع", "ZH-CHS": "调整高度"},
    lift_route: {EN: "Lift Route", AR: "طريق المصعد", "ZH-CHS": "电梯路线"},
    go_to_nearest: { EN: "Show nearest",  AR: "أرني الأقرب", "ZH-CHS": "显示最近的"},

    search_in: { EN: "Search in", AR: "البحث في", "ZH-CHS": "搜索范围" },
    searchtext_placeholder: {
        EN: "What are you looking for?",
        AR: "ما الذي تبحث عنه؟",
        "ZH-CHS": "您在寻找什么?"
    },
    by_tag_results: {EN: "Related", AR: "ذات الصلة", "ZH-CHS": "相关内容"},
    by_match_results: {EN: "More matching results", AR: "المزيد من النتائج المطابقة", "ZH-CHS": "更多匹配结果"},

    more_results: {
        EN: "There's more, type to filter",
        AR: "هناك المزيد ، اكتب للتصفية",
        "ZH-CHS": "还有更多，输入进行筛选"
    },
    no_results_1: {
        EN: "Sorry, there are no results for your search",
        AR: "عذرا، لا توجد نتائج لبحثك",
        "ZH-CHS": "抱歉，没有您搜索的结果"
    },
    no_results_2: {
        EN: "Need help finding something? Call 800 MOE MALL (663 6255)",
        AR: "مازلت بحاجة الى المساعدة ؟ اتصل على 800 MOE MALL (663 6255) "
    },
    suggest_title: {
        EN: "Here are some suggestions based on your search",
        AR: "فيما يلي بعض الاقتراحات بناءً على بحثك",
        "ZH-CHS": "根据您的搜索提供以下建议"
    },
    submit_title: {
        EN: "Not found? please finish typing and tap [Submit] to let us know:",
        AR: "بحث غير موجود؟ يُرجى إنهاء الكتابة والنقر على [إرسال] لإعلامنا :",
        "ZH-CHS": "未找到？请完成输入，然后点击 [提交] 让我们知道："
    },

    pan: { EN: "Move", AR: "يتحرك", "ZH-CHS": "移动"},
    zoom_rotate: { EN: "Zoom/Rotate", AR: "تكبير/تدوير", "ZH-CHS": "缩放/旋转"},

    u_r_here: {
        EN: "YOU<br>ARE<br>HERE",
        AR: "<br>أنت هنا<br>",
        "ZH-CHS": "现在<br>位置"
    },
    show_on_map: {EN: "Show on Map", AR: "عرض على الخريطة", "ZH-CHS": "显示在地图上"},
    directions: {EN: "Show directions", AR: "عرض الاتجاهات", "ZH-CHS": "显示路线"},
    show_deals: {EN: "Show Promotions", AR: "إظهار العروض", "ZH-CHS": "显示促销活动"},
    hide_deals: {EN: "Hide Promotions", AR: "إخفاء العروض", "ZH-CHS": "隐藏促销活动"},

    qr_code_title: {
        EN: "SCAN FOR MAP",
        AR: "امسح للخريطة",
        "ZH-CHS": "扫描以获取商场指南"
    },
    poi_qr_title: {
        EN: "Get the directions on your mobile",
        AR: "احصل على الاتجاهات <br> على هاتفك المحمول",
        "ZH-CHS": "在您的手机上<br>查看路线"
    },
    opsoon_title: {
        EN: "Opening soon",
        AR: "قريبا الافتتاح",
        "ZH-CHS": "即将开幕",
    },
    from: {EN: ' From ', AR: ' من ', "ZH-CHS": ' 从 '},
    to: {EN: ' to ', AR: ' إلى ', "ZH-CHS": ' 至 '},
    on: {EN: ' on ', AR: ' على ', "ZH-CHS": ' 在…上 '},
    in: {EN: ' in ', AR: ' في ', "ZH-CHS": ' 在…中 '},
    or: {EN: ' OR ', AR: ' أو ', "ZH-CHS": ' 或者 '},

    startAt: {EN: 'Starting at ', AR: 'يبدأ من ', "ZH-CHS": ' 从 '},
    yourPosition: {EN: ' your position ', AR: ' موقعك ', "ZH-CHS": ' 您的位置 '},
    yourDestination: {EN: ' your destination ', AR: ' وجهتك ', "ZH-CHS": ' 您的目的地 '},
    take_the: {EN: 'Take the ', AR: 'خذ ', "ZH-CHS": '前往 '},
    walk: {EN: 'Walk to ', AR: 'امشي الى ', "ZH-CHS": '步行到 '},
    continue: {EN: ' continue on ', AR: ' اكمل في ', "ZH-CHS": ' 继续前往 '},
    to_level: {EN: ' to level ', AR: ' الى ألطابق ', "ZH-CHS": ' 到…层 '},
    less_min: { EN: "less than a min", AR: " أقل من دقيقة ", "ZH-CHS": '不到1分钟'},
    around: { EN: " around ", AR: " حوالي ", "ZH-CHS": ' 约 '},
    min: { EN: " min", AR: " دقيقة ", "ZH-CHS": ' 分钟'},
    part_next: { EN: "Next", AR: "التالي", "ZH-CHS": ' 下一步 '},
    part_prev: { EN: "Previous", AR: "السابق", "ZH-CHS": ' 上一步 '},

    ur_looking_this_way: {
        EN: "You are here facing this way",
        AR: "أنت هنا تنظر في هذا الاتجاه",
        "ZH-CHS": "您目前的定位"
    },
    start_walk_this_way: {
        EN: "Start walking this way",
        AR: "ابدء في المشي هذا الاتجاه",
        "ZH-CHS": "开始朝这边走"
    },

    fmc_title: {
        EN: "Find My Car",
        "ZH-CHS": "Find My Car"
    },
    fmc_get_platenum: {
        EN: "Enter your vehicle number",
        "ZH-CHS": "Enter your vehicle number"
    },
    fmc_results_title: {
        EN: "FMC Results",
        "ZH-CHS": "FMC Results"
    },
    fmc_no_results: {
        EN: "Sorry, vehicle not found",
        "ZH-CHS": "Sorry, vehicle not found"
    },
	
	lot: {EN: "Lot ", "ZH-CHS": ''}
};

//Object.entries(translations).forEach(function(e) { console.log(e[0] + ";" + e[1].EN + ";" + e[1].AR + ";" + e[1].ZH); });

const custom_kb_layouts = {
    qwerty: {
        normal: ["Q W E R T Y U I O P {bksp}", "{shift} A S D F G H J K L & {shift}", "Z X C V {space} B N M"],
        shift: ["1 2 3 4 5 6 7 8 9 0 {bksp}", "! @ # $ % ; ' * ( ) - +", "{normal} {space} ? : {normal}"]
    },
    azerty: {
        normal: ["A Z E R T Y U I O P {bksp}", "{shift} Q S D F G H J K L M {shift}", "W X C V {space} B N &"],
        shift: ["1 2 3 4 5 6 7 8 9 0 {bksp}", "! @ # $ % ; ' * ( ) - +", "{normal} {space} ? : {normal}"]
    },
    pinyin: {
        shift: ["1 2 3 4 5 6 7 8 9 0 {bksp}", "! @ # $ % ; ' * - +", "{normal} {space} ? : {normal}"],
        normal: [
            "\u624B \u7530 \u6C34 \u53E3 \u5EFF \u535C \u5C71 \u6208 \u4EBA \u5FC3 {bksp}",
            "\u65E5 \u5C38 \u6728 \u706B \u571F \u7AF9 \u5341 \u5927 \u4E2D ",
            "{shift} \uFF3A \u96E3 \u91D1 \u5973 \u6708 \u5F13 \u4E00 & {shift}",
            "{space}"]
    },
    arabic: {
        normal: ["ض ص ث ق ف غ ع ه خ ح ج د {bksp}", "{shift} ذ ش س ي ب ل ا ت ن م ك ط {shift}", "أ ئ ء ؤ ر لا {space} ى ة و ز ظ"],
        shift: ["1 2 3 4 5 6 7 8 9 0 - = {bksp}", "ّ ! @ # $ % & * ' _ + ", '{normal} ٍ  لأ ـ {space} ، / : {normal}']
    },
    numerical: {
        normal: ["1 2 3", "4 5 6", "7 8 9", "{empty} 0 {bksp}"]
    },

};