translations.searchtext_placeholder = { EN: "", "ZH-CHS": "" };
baseOpts.mapSelect = false;

const fmcUrl = "http://180.255.64.154:88/intf_findcar/f_findcar.php"; // Dev Server - "http://27.54.43.37/weilongintf/intf_findcar/f_findcar.php" - vehicleNum (1512, 786)
const fmcKey = "7AeT0pWbz0SqFyNFv1h7dgz4Wl9xu0"; // Dev Server - "12345678"

showMainPanel = function() {
    showSearchPanel(null, { keyboard: true, keyboardLayout: 'numerical', clear: true });
    $("#fmcSearch").addClass('disabled');
}

setSearchKeyboard = function() {
    setKeyboardForInput("#searchtext", onKeyboardChange, true, "numerical");
}

handleBaseSearchKbInput = function(val) {
    const len = val ? val.trim().length : 0;
    if (len > 0) {
        $("#searchTextClear").show();
        $("#fmcSearch").removeClass('disabled');
    } else {
        $("#searchtext").val("");
        $("#searchTextClear").hide();
        $("#fmcSearch").addClass('disabled');
    }
}

clearSearchText = function() {
    $("#searchTextClear").hide();
    $("#searchtext").val("");
    $("#searchResultsWrapper").html("");
    $("#fmcSearch").addClass('disabled');
}

async function fmcSearch() {
    const plateNumber = $("#searchtext").val()?.trim();
    const len = plateNumber ? plateNumber.length : 0;

    if(len > 0) {
        const dateStr = AMapUtils.getDateISOString(new Date(), " "); // "2023-06-21 12:13:14"
        const md5 = await hashwasm.md5(fmcKey + dateStr); // "12ec3f66688f4371aed813becb8e56f0"

        $("#fmcSearch").addClass('disabled');
        $("#searchResultsWrapper").html("<div style='width:100%; text-align: center;'><img src='/app/assets/images/icons/working.gif' alt='searching..'></div>");

        $.ajax({
            method: "POST",
            url: getProxyUrl(),
            headers: {
                "X-Proxy-Url": fmcUrl,
                "Content-Type": "application/json"
            },
            data: JSON.stringify({
                securityToken: md5,
                vehicleNum: plateNumber,
                datetime: dateStr
            }),
            dataType: "json",
            contentType: "application/json",
            crossDomain: true,
            success: function (response) {
                const items = (response.item || []).filter(e => (e.licenseNumber?.replace(/[^0-9]/g,"").length === len));

                populateSearchResults(items.length > 0 ? [
                    { items: items, title: getTrans("fmc_results_title"), clazz: "parking-lot", type: "poi" },
                ] : [], items.length);

                $("#searchResultsWrapper div.parking-item").on('click', function() {
                    const id = $(this).attr("data-filter");
                    const ind = Number.parseInt(id);
                    if(Number.isInteger(ind)) {
                        fmcPathToParking(items[ind]);
                    }
                });

                $("#fmcSearch").removeClass('disabled');
            },
            error: function (xhr, ajaxOptions, thrownError) {
                $("#searchResultsWrapper").html("<div style='width:100%; text-align: center; font-size: 4rem;'>Sorry, unable to process your request</div>");
                console.log("Error FMC:", xhr.status, thrownError);
                $("#fmcSearch").removeClass('disabled');
            }
        });
    }
}

 function fmcPathToParking(elem) {
    if(elem.geoID) {
        const node = getAMap().getElementByGeoId(elem.geoID);
        if (node) {
            showMapPanel("search");
            onSelectPoi({
                title: [ { lang: "EN", value: elem.licenseNumber } ],
                active: true,
                geoId: elem.geoID,
                media: elem.img_Url,
                levelName: elem.level,
                zoneName: (elem.parkingZoneCode || "-"),
                pillar: (elem.pillar || "-"),
                slotID: elem.slotID
            }, node, false, true);
        }
    }
}